% Section 10.5.2, Sensor Fault Case
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System
H1 = 4; H2 = 5.1; H3 = 5.1;
D1 = 5; D2 = 3; D3 = 3;
Tm1 = 0.35; Tm2 = 0.35; Tm3 = 0.35;
Te1 = 0.1; Te2 = 0.1; Te3 = 0.1;
R1 = 0.05; R2 = 0.05; R3 = 0.05; 
Km1 = 1; Km2 = 1; Km3 = 1; 
Ke1 = 1; Ke2 = 1; Ke3 = 1;
w01 = 314.159; w02 = 314.159; w03 = 314.159; 
% alpha12 = -27.49; alpha13 = -27.49; alpha21 = -23.10; alpha23 = -23.10;  alpha31 = -23.10; alpha32 = -23.10;

A1 = [0 1 0 0;0 -D1/(2*H1) w01/(2*H1) 0; 0 0 -1/Tm1 Km1/Tm1; 0 -Ke1/(Te1*R1*w01) 0 -1/Te1]; % 4*4
B1 = [0; 0; 0; 1/Te1]; 
C1 = eye(4); 
Fs1 = [1;1;0;-1];

A2 = [0 1 0 0;0 -D2/(2*H2) w02/(2*H2) 0; 0 0 -1/Tm2 Km2/Tm2; 0 -Ke2/(Te2*R2*w02) 0 -1/Te2]; % 4*4
B2 = [0; 0; 0; 1/Te2]; 
C2 = eye(4); 
Fs2 = [-1;1;-1;0];

A3 = [0 1 0 0;0 -D3/(2*H3) w03/(2*H3) 0; 0 0 -1/Tm3 Km3/Tm3; 0 -Ke3/(Te3*R3*w03) 0 -1/Te3]; % 4*4
B3 = [0; 0; 0; 1/Te3]; 
C3 = eye(4); 
Fs3 = [1;-1;1;-1];


% Design FE observer and FTC controller
H01 = [1 zeros(1,3) -1 zeros(1,3) 0 zeros(1,3);
                        1 zeros(1,3) 0 zeros(1,3) -1 zeros(1,3)]';
  
H02 = [-1 zeros(1,3) 1 zeros(1,3) 0 zeros(1,3);
                         0 zeros(1,3) 1 zeros(1,3) -1 zeros(1,3)]';
  
H03 = [-1 zeros(1,3) 0 zeros(1,3) 1 zeros(1,3);
                        0 zeros(1,3) -1 zeros(1,3) 1 zeros(1,3)]';


[Kx1,G1,M1,L1,H1,Kx2,G2,M2,L2,H2,Kx3,G3,M3,L3,H3] = Observer_controller_design(A1,B1,Fs1,C1,A2,B2,Fs2,C2,A3,B3,Fs3,C3,H01,H02,H03)

% Define global variables to store data
global ffs1 ffs2 ffs3 hat_ffs1 hat_ffs2 hat_ffs3 Int_ts Int_count Int_tmp 

% Store FTC data
global yy11 yy12 yy13 yy14 yy21 yy22 yy23 yy24 yy31 yy32 yy33 yy34 

% Store nominal control data
global yyn11 yyn12 yyn13 yyn14 yyn21 yyn22 yyn23 yyn24 yyn31 yyn32 yyn33 yyn34

ffs1 = []; ffs2 = []; ffs3 = []; hat_ffs1 = []; hat_ffs2 = []; hat_ffs3 = [];  Int_ts = []; Int_count = 0; 
Int_tmp = 0; yy11 = []; yy12 = []; yy13 = []; yy14 = []; yy21 = []; yy22 = []; yy23 = []; yy24 = [];
yy31 = []; yy32 = []; yy33 = []; yy34 = [];

yyn11 = []; yyn12 = []; yyn13 = []; yyn14 = []; yyn21 = []; yyn22 = []; yyn23 = []; yyn24 = [];
yyn31 = []; yyn32 = []; yyn33 = []; yyn34 = [];

% Initial conditon
x0 = [0; 1; 0.5; -1; 0.1; 0.5; -0.1; 0.5; 1; 0.2; 0.5; 0];
z0 = zeros(15,1);

para = [z0',x0'];

% Simulation time
t0 = 0;
tf = 5;
tspan = [t0 tf];

% Closed-loop simulation
[Int_tt,Int_yy] = ode45(@(t,xx) Closed_sys_performance(t,xx,A1,B1,Fs1,C1,A2,B2,Fs2,C2,A3,B3,Fs3,C3,Kx1,G1,M1,L1,H1,Kx2,G2,M2,L2,H2,Kx3,G3,M3,L3,H3), tspan, para);


% draw figures
run('Draw_figures.m');
